/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.kop.app.KopProcessImageParser;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogNetworkNodeBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.NetworkNodeBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.SAnalogOutputBlock;
import DE.siemens.ad.logo.model.block.SOutputBlock;
import DE.siemens.ad.logo.util.DataExchange;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.simulation.ActualValueVisitor;
import DE.siemens.ad.pdraw.simulation.OnlineTestProtocolHandler;
import DE.siemens.ad.pdraw.simulation.ProcessImageParser;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.udf.UDFBlock;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class OnlineTestInterpreter
extends Interpreter {
    private DataTransfer fDataTransfer;
    protected List fOutputBlocks;
    protected List fIMOutputBlocks;
    protected Object[] fNetworkBlocks;
    protected List fInputBlocks;
    public static final int TRANSMISSION_ERROR = 1;
    protected Vector fObservedBinaryConnectors = new Vector();
    protected ValueDispatcher fValueDispatcher;
    protected OnlineTestProtocolHandler fOnlineTestProtocolHandler;
    protected DataExchange fTelegramBuffer;
    protected int[] fDataTableReadReqOld;
    protected int[] fDataTableReadReqNew;
    public static MessageDataCenter fMessageDataCenter = new MessageDataCenter();

    public void prepareInterpreter() {
        super.prepareInterpreter();
        this.fNetworkBlocks = this.getNetworkBlocks().toArray();
        this.sortNetworkBlock(this.fNetworkBlocks);
        this.fOutputBlocks = this.fWiringDiagram.getOutputBlocks();
        this.fIMOutputBlocks = this.fWiringDiagram instanceof WiringDiagramKop ? ((WiringDiagramKop)this.fWiringDiagram).getIMOutputBlocks() : new Vector();
        this.fInputBlocks = this.fWiringDiagram.getInputBlocks();
        this.fObservedBinaryConnectors.removeAllElements();
        Enumeration enumeration = this.fWiringDiagram.getAllOutConnectors().elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof BinaryOutBlockConnector)) continue;
            this.fObservedBinaryConnectors.add(o);
        }
        if (this.fWiringDiagram instanceof WiringDiagramKop) {
            this.fObservedBinaryConnectors.add(((WiringDiagramKop)this.fWiringDiagram).getLeftPowerRailBlock().getOutConnector(0));
        }
        Hardware hardware = this.fWiringDiagram.getHardware();
        int checksum = -1;
        try {
            checksum = ((Logo)hardware).getChecksum(this.fWiringDiagram);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fWiringDiagram.setOldChecksum(checksum);
        this.fWiringDiagram.netOn(this, true);
    }

    public Vector getNetworkBlocks() {
        Vector<Block> networkBlocks = new Vector<Block>();
        Enumeration blockEnum = this.fWiringDiagram.getBlocks().elements();
        Block block = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            if (!(block instanceof NetworkNodeBlock) && !(block instanceof SOutputBlock)) continue;
            networkBlocks.add(block);
        }
        return networkBlocks;
    }

    private void sortNetworkBlock(Object[] source) {
        Block inBlock = null;
        for (int out = 1; out < source.length; ++out) {
            Block temp = (Block)source[out];
            for (int in = out; in > 0 && (inBlock = (Block)source[in - 1]).getNumberType() >= temp.getNumberType() && (inBlock.getNumberType() != temp.getNumberType() || inBlock.getNumber() >= temp.getNumber()); --in) {
                source[in] = source[in - 1];
            }
            source[in] = temp;
        }
    }

    public OnlineTestInterpreter(LogoDrawing drawing) {
        this.fLogoDrawing = drawing;
        this.fWiringDiagram = this.fLogoDrawing.getWiringDiagram();
        this.init(this.fWiringDiagram);
    }

    private void init(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
        this.fTelegramBuffer = new DataExchange();
        this.fOnlineTestProtocolHandler = new OnlineTestProtocolHandler(this.fTelegramBuffer);
        this.fOnlineTestProtocolHandler.setWiringDiagram(this.fWiringDiagram);
    }

    public void setWiringDiagram(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
        this.fOnlineTestProtocolHandler.setWiringDiagram(this.fWiringDiagram);
    }

    public StateMachine getStateMachine() {
        return this.fOnlineTestProtocolHandler.getStateMachine();
    }

    public void start() {
        this.fOnlineTestProtocolHandler.setRequestedBlocks(new Vector());
        this.fOnlineTestProtocolHandler.setDataTransfer(this.fDataTransfer);
        this.fOnlineTestProtocolHandler.getStateMachine().start();
        new Thread((Runnable)this.getValueDispatcher(), "ValueDispatcher").start();
    }

    public long getCurrentSimulationClockTime() {
        return 0L;
    }

    public long getCurrentSimulationTimerTime() {
        return 0L;
    }

    public DataTransfer getDataTransfer() {
        return this.fDataTransfer;
    }

    public void setDataTransfer(DataTransfer dataTransfer) {
        this.fDataTransfer = dataTransfer;
    }

    public int getReadReqChecksum(int[] dataTableReadReq) {
        int checksum = 0;
        if (dataTableReadReq != null) {
            int counter = dataTableReadReq[0];
            checksum = dataTableReadReq[3 * counter + 1] | dataTableReadReq[3 * counter + 2] << 8;
        }
        return checksum;
    }

    public ValueDispatcher getValueDispatcher() {
        if (this.fValueDispatcher == null) {
            this.fValueDispatcher = new ValueDispatcher(this.fTelegramBuffer, this.fDataTransfer.getHardware(), this.fWiringDiagram);
        } else {
            this.fValueDispatcher.init(this.fTelegramBuffer, this.fDataTransfer.getHardware(), this.fWiringDiagram);
        }
        return this.fValueDispatcher;
    }

    public void setRequestedBlocks(List requestedBlocks) {
        this.fOnlineTestProtocolHandler.setRequestedBlocks(requestedBlocks);
    }

    public void setReadRequestedData(int[] dataTableReadReq) {
        this.fDataTableReadReqOld = this.fDataTableReadReqNew;
        this.fDataTableReadReqNew = dataTableReadReq;
    }

    public static class MessageDataCenter {
        private static final int CONTENTS_WIDTH = 18;
        private int[] lineContents = new int[72];
        private int[] lineOffsets = new int[4];
        private int fCurrentMsgNumber = -1;
        private int fCurrentMsgCharsetID = 0;
        private boolean fIsNoMsgDisplayOnBM;

        public boolean isNoMsgDisplayOnBM() {
            return this.fIsNoMsgDisplayOnBM;
        }

        public void setIsNoMsgDisplayOnBM(boolean isMsgDisplayOnBM) {
            this.fIsNoMsgDisplayOnBM = isMsgDisplayOnBM;
        }

        public int getCurrentMsgNumber() {
            return this.fCurrentMsgNumber;
        }

        public int getCurrentMsgCharsetID() {
            return this.fCurrentMsgCharsetID;
        }

        public int[] getLineOffsets() {
            return this.lineOffsets;
        }

        public int getValue(int x, int y) {
            if (x < -1 || x > 18 || y < 0 || y > 4) {
                return 32;
            }
            return this.lineContents[18 * y + x + 1];
        }

        public void setBuffer(int[] buffer) {
            int index = 0;
            if (buffer.length > 0 && !this.fIsNoMsgDisplayOnBM) {
                int i;
                this.fCurrentMsgNumber = buffer[index] & 0x7F;
                this.fCurrentMsgCharsetID = (buffer[index] & 0x80) >> 7;
                if (buffer.length < 2) {
                    return;
                }
                int barCount = buffer[++index];
                index += 2;
                for (i = 0; i < 4; ++i) {
                    this.lineOffsets[i] = buffer[index];
                    ++index;
                }
                for (i = 0; i < 72; ++i) {
                    this.lineContents[i] = buffer[index];
                    ++index;
                }
                for (i = 0; i < barCount; ++i) {
                    int pos = buffer[index];
                    int x = pos & 0x1F;
                    int y = pos >> 5 & 7;
                    if ((x -= this.lineOffsets[y]) < -1) {
                        x = -1;
                    }
                    this.lineContents[18 * y + x + 1] = buffer[++index];
                    this.lineContents[18 * y + x + 2] = buffer[++index];
                    ++index;
                }
            } else {
                int i;
                this.fCurrentMsgNumber = -1;
                this.fCurrentMsgCharsetID = 0;
                for (i = 0; i < 4; ++i) {
                    this.lineOffsets[i] = 0;
                }
                for (i = 0; i < 72; ++i) {
                    this.lineContents[i] = 32;
                }
            }
        }
    }

    public class ValueDispatcher
    extends Thread {
        protected DataExchange fTelegramExchange;
        protected OnlineTestTelegramBuffer fTelegram;
        protected ProcessImageParser fProcessImageParser;
        protected ProcessImageParser fProcessImageParserFup;
        protected KopProcessImageParser fProcessImageParserKop;
        protected boolean fSupportMsgOnlineTest;
        protected boolean fSupportDataTable;
        protected boolean fSupportNetwork;
        protected ActualValueVisitor fActualValueVisitor;

        public ValueDispatcher(DataExchange telegramBuffer, Hardware hardware, WiringDiagram wd) {
            this.init(telegramBuffer, hardware, wd);
        }

        public void init(DataExchange telegramBuffer, Hardware hardware, WiringDiagram wd) {
            this.fTelegramExchange = telegramBuffer;
            if (wd instanceof WiringDiagramKop) {
                if (this.fProcessImageParserKop == null) {
                    this.fProcessImageParserKop = new KopProcessImageParser(hardware);
                } else {
                    this.fProcessImageParserKop.setHardware(hardware);
                }
                this.fProcessImageParser = this.fProcessImageParserKop;
            } else {
                if (this.fProcessImageParserFup == null) {
                    this.fProcessImageParserFup = new ProcessImageParser(hardware);
                } else {
                    this.fProcessImageParserFup.setHardware(hardware);
                }
                this.fProcessImageParser = this.fProcessImageParserFup;
            }
            this.fActualValueVisitor = ((Logo)hardware).getActualValueVisitor();
            this.fSupportMsgOnlineTest = hardware.supports("SupportMessageOnlineTest");
            this.fSupportDataTable = hardware.supports("supportDataTable");
            this.fSupportNetwork = hardware.supports("supportNetwork");
        }

        public void run() {
            int[] buffer = null;
            while (OnlineTestInterpreter.this.getStateMachine().isRunning()) {
                if (this != OnlineTestInterpreter.this.fValueDispatcher) {
                    return;
                }
                this.fTelegram = (OnlineTestTelegramBuffer)this.fTelegramExchange.getData();
                buffer = this.fTelegram.getBytes();
                if (buffer == null) continue;
                this.parseSimulationTelegram(buffer);
                this.dispatchValues();
                OnlineTestInterpreter.this.fireCycleFinishedEvent(true);
            }
        }

        private void dispatchValues() {
            this.dispatchIOValue();
            this.dispatchBinaryConnector();
            this.dispatchWatchedBlock();
            this.dispatchNetworkInfo();
        }

        private void dispatchIOValue() {
            for (OutputBlock outputBlock : OnlineTestInterpreter.this.fOutputBlocks) {
                if (outputBlock.getOutConnectorCount() <= 0) continue;
                if (outputBlock.getOutConnector(0).getSignalType() == 0) {
                    boolean binaryValue = this.fProcessImageParser.getDigitalValue(outputBlock);
                    outputBlock.setBinaryValue(binaryValue);
                }
                if (outputBlock.getOutConnector(0).getSignalType() != 1) continue;
                double analogValue = this.fProcessImageParser.getAnalogValue(outputBlock);
                outputBlock.setAnalogValue(analogValue);
            }
            for (InputBlock inputBlock : OnlineTestInterpreter.this.fInputBlocks) {
                AbstractInputSimulationParameter simulationParameter = (AbstractInputSimulationParameter)inputBlock.getSimulationParameter();
                if (simulationParameter instanceof InputSimulationParameter) {
                    boolean binaryValue = this.fProcessImageParser.getDigitalValue(inputBlock);
                    simulationParameter.setBinaryValue(binaryValue);
                }
                if (!(simulationParameter instanceof AnalogInputSimulationParameter)) continue;
                double analogValue = this.fProcessImageParser.getAnalogValue(inputBlock);
                simulationParameter.setInternAnalogValue(analogValue);
            }
        }

        private void dispatchBinaryConnector() {
            boolean findChanged;
            for (BinaryOutBlockConnector outBlockConnector : OnlineTestInterpreter.this.fObservedBinaryConnectors) {
                boolean binaryValue = this.fProcessImageParser.getDigitalValue(outBlockConnector.getOwner());
                outBlockConnector.setBinaryValue(binaryValue);
            }
            int times = 0;
            do {
                boolean binaryValue;
                Iterator i = OnlineTestInterpreter.this.fIMOutputBlocks.iterator();
                findChanged = false;
                while (i.hasNext()) {
                    OutputBlock outputBlock = (OutputBlock)i.next();
                    if (outputBlock.getOutConnectorCount() <= 0) continue;
                    binaryValue = ((KopProcessImageParser)this.fProcessImageParser).getIMOutputValue(outputBlock);
                    if (outputBlock.getBinaryValue() == binaryValue) continue;
                    outputBlock.setBinaryValue(binaryValue);
                    findChanged = true;
                    break;
                }
                for (BinaryOutBlockConnector outBlockConnector : OnlineTestInterpreter.this.fObservedBinaryConnectors) {
                    if (!(outBlockConnector.getOwner() instanceof ContactBlock) || !((KopProcessImageParser)this.fProcessImageParser).isInternalMarker(((ContactBlock)outBlockConnector.getOwner()).getReferencedOutConnector().getOwner())) continue;
                    binaryValue = this.fProcessImageParser.getDigitalValue(outBlockConnector.getOwner());
                    if (outBlockConnector.getBinaryValue() == binaryValue) continue;
                    outBlockConnector.setBinaryValue(binaryValue);
                    findChanged = true;
                }
                if (++times <= 32) continue;
                System.err.println("Dispatch Values for IM exit. Too deep recursion.");
                break;
            } while (findChanged);
        }

        private void dispatchWatchedBlock() {
            HashMap watchedPIDBlockRefMap = new HashMap();
            for (Block watchedBlock : this.fTelegram.getWatchedBlocks()) {
                AnalogOrBlockReference ref;
                if (!(watchedBlock instanceof PIDBlock) || (ref = ((PIDParameter)((PIDBlock)watchedBlock).getParameter()).getSetpoint()).getReference() == null) continue;
                if (watchedPIDBlockRefMap.containsKey(ref.getReferenceToBlock())) {
                    ((List)watchedPIDBlockRefMap.get(ref.getReferenceToBlock())).add(watchedBlock);
                    continue;
                }
                ArrayList<Block> list = new ArrayList<Block>();
                list.add(watchedBlock);
                watchedPIDBlockRefMap.put(ref.getReferenceToBlock(), list);
            }
            HashMap<UDFBlock, String> UDFParaTextMap = new HashMap<UDFBlock, String>();
            for (Block watchedBlock : this.fTelegram.getWatchedBlocks()) {
                Block udf = OnlineTestInterpreter.this.fWiringDiagram.getOutestBlock(watchedBlock);
                if (udf instanceof UDFBlock) {
                    if (UDFParaTextMap.get(udf) == null) {
                        UDFParaTextMap.put((UDFBlock)udf, (String)watchedBlock.acceptVisitor(this.fActualValueVisitor) + "\n");
                        continue;
                    }
                    UDFParaTextMap.put((UDFBlock)udf, (String)UDFParaTextMap.get(udf) + (String)watchedBlock.acceptVisitor(this.fActualValueVisitor) + "\n");
                    continue;
                }
                String currentParameterString = (String)watchedBlock.acceptVisitor(this.fActualValueVisitor);
                watchedBlock.getParameter().setCurrentParameterText(currentParameterString);
                if (!watchedPIDBlockRefMap.containsKey(watchedBlock)) continue;
                List refPIDBlock = (List)watchedPIDBlockRefMap.get(watchedBlock);
                Iterator PIDBlockIter = refPIDBlock.iterator();
                while (PIDBlockIter.hasNext()) {
                    ((PIDBlock)PIDBlockIter.next()).setOnlineTestSP(Integer.valueOf(currentParameterString.trim()));
                }
            }
            for (Block udf : UDFParaTextMap.keySet()) {
                String paraText = (String)UDFParaTextMap.get(udf);
                udf.getParameter().setCurrentParameterText(paraText);
            }
        }

        private void dispatchNetworkInfo() {
            int index;
            int[] networkImage = this.fProcessImageParser.getNetworkInfoImage();
            if (OnlineTestInterpreter.this.fNetworkBlocks.length == 0) {
                return;
            }
            int byteOffset = 0;
            int bitOffset = 0;
            boolean hasNetworkBlock = false;
            boolean hasSOutputBlock = false;
            for (index = 0; index < OnlineTestInterpreter.this.fNetworkBlocks.length && OnlineTestInterpreter.this.fNetworkBlocks[index].getClass() == NetworkNodeBlock.class; ++index) {
                hasNetworkBlock = true;
                byteOffset = index / 8;
                bitOffset = index % 8;
                boolean value = (networkImage[byteOffset] >> bitOffset & 1) == 1;
                ((BinaryOutBlockConnector)((Block)OnlineTestInterpreter.this.fNetworkBlocks[index]).getOutConnector(0)).setBinaryValue(value);
            }
            if (hasNetworkBlock) {
                ++byteOffset;
            }
            while (index < OnlineTestInterpreter.this.fNetworkBlocks.length && OnlineTestInterpreter.this.fNetworkBlocks[index].getClass() == AnalogNetworkNodeBlock.class) {
                byteOffset += 2;
                ++index;
            }
            int temp = index;
            while (index < OnlineTestInterpreter.this.fNetworkBlocks.length && OnlineTestInterpreter.this.fNetworkBlocks[index].getClass() == SOutputBlock.class) {
                hasSOutputBlock = true;
                bitOffset = (index - temp) % 8;
                boolean value = (networkImage[byteOffset] >> bitOffset & 1) == 1;
                ((SOutputBlock)OnlineTestInterpreter.this.fNetworkBlocks[index]).setBinaryValue(value);
                if ((index - temp) / 8 == 1) {
                    ++byteOffset;
                    temp += 8;
                }
                ++index;
            }
            if (hasSOutputBlock) {
                ++byteOffset;
            }
            while (index < OnlineTestInterpreter.this.fNetworkBlocks.length && OnlineTestInterpreter.this.fNetworkBlocks[index].getClass() == SAnalogOutputBlock.class) {
                ((SAnalogOutputBlock)OnlineTestInterpreter.this.fNetworkBlocks[index]).setAnalogValue(Util.makeWord(networkImage[byteOffset], networkImage[byteOffset + 1]));
                byteOffset += 2;
                ++index;
            }
        }

        protected void parseSimulationTelegram(int[] buffer) {
            int blockResultValuesLength = buffer[2];
            int processImageLength = buffer[3];
            int actValueLength = buffer[4];
            int index = 5;
            int networkInfoLength = 0;
            if (this.fSupportNetwork) {
                networkInfoLength = buffer[index];
                ++index;
            }
            int msgValueLength = 0;
            if (this.fSupportMsgOnlineTest) {
                msgValueLength = (buffer[index] & 0xFE) >> 1;
                fMessageDataCenter.setIsNoMsgDisplayOnBM((buffer[index] & 1) == 1);
                ++index;
            }
            int dtValueLength = 0;
            if (this.fSupportDataTable) {
                dtValueLength = buffer[index];
                ++index;
            }
            int[] blockResultBuffer = new int[blockResultValuesLength];
            System.arraycopy(buffer, index, blockResultBuffer, 0, blockResultValuesLength);
            int[] processImageBuffer = new int[processImageLength];
            System.arraycopy(buffer, index += blockResultValuesLength, processImageBuffer, 0, processImageLength);
            int[] actValueBuffer = new int[actValueLength];
            System.arraycopy(buffer, index += processImageLength, actValueBuffer, 0, actValueLength);
            int[] networkInfoBuffer = new int[networkInfoLength];
            System.arraycopy(buffer, index += actValueLength, networkInfoBuffer, 0, networkInfoLength);
            int[] msgOnlineTestBuffer = new int[msgValueLength];
            System.arraycopy(buffer, index += networkInfoLength, msgOnlineTestBuffer, 0, msgValueLength);
            int[] dtOnlineTestBuffer = new int[dtValueLength];
            System.arraycopy(buffer, index += msgValueLength, dtOnlineTestBuffer, 0, dtValueLength);
            this.fProcessImageParser.setProcessImage(processImageBuffer);
            this.fProcessImageParser.setBlockResultImage(blockResultBuffer);
            this.fActualValueVisitor.setBuffer(actValueBuffer);
            if (this.fSupportNetwork) {
                this.fProcessImageParser.setNetworkInfoImage(networkInfoBuffer);
            }
            if (this.fSupportMsgOnlineTest) {
                fMessageDataCenter.setBuffer(msgOnlineTestBuffer);
            }
            if (this.fSupportDataTable) {
                this.fillVMValueOfDataTable(dtOnlineTestBuffer);
            }
        }

        private void fillVMValueOfDataTable(int[] dtOnlineTestBuffer) {
            if (dtOnlineTestBuffer.length > 2) {
                int checksum = dtOnlineTestBuffer[0] | dtOnlineTestBuffer[1] << 8;
                if (OnlineTestInterpreter.this.fDataTableReadReqNew != null && checksum == OnlineTestInterpreter.this.getReadReqChecksum(OnlineTestInterpreter.this.fDataTableReadReqNew)) {
                    this.writeVMViaReadBuffer(dtOnlineTestBuffer, OnlineTestInterpreter.this.fDataTableReadReqNew);
                } else if (OnlineTestInterpreter.this.fDataTableReadReqOld != null && checksum == OnlineTestInterpreter.this.getReadReqChecksum(OnlineTestInterpreter.this.fDataTableReadReqOld)) {
                    this.writeVMViaReadBuffer(dtOnlineTestBuffer, OnlineTestInterpreter.this.fDataTableReadReqOld);
                }
            }
        }

        private void writeVMViaReadBuffer(int[] dtOnlineTestBuffer, int[] dataTableReadReqBuffer) {
            int bufferIndex = 2;
            for (int i = 1; i < dataTableReadReqBuffer.length - 2; i += 3) {
                int addr = Util.makeWord(dataTableReadReqBuffer[i], dataTableReadReqBuffer[i + 1]);
                int length = dataTableReadReqBuffer[i + 2];
                int newValue = 0;
                if (length == 1) {
                    if (bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    newValue = dtOnlineTestBuffer[bufferIndex];
                    ++bufferIndex;
                } else if (length == 2) {
                    if (bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    int lowByte = dtOnlineTestBuffer[bufferIndex];
                    if (++bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    int highByte = dtOnlineTestBuffer[bufferIndex];
                    ++bufferIndex;
                    newValue = Util.makeWord(highByte, lowByte);
                } else if (length == 4) {
                    if (bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    int byte0 = dtOnlineTestBuffer[bufferIndex];
                    if (++bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    int byte1 = dtOnlineTestBuffer[bufferIndex];
                    if (++bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    int byte2 = dtOnlineTestBuffer[bufferIndex];
                    if (++bufferIndex >= dtOnlineTestBuffer.length) {
                        return;
                    }
                    int byte3 = dtOnlineTestBuffer[bufferIndex];
                    ++bufferIndex;
                    newValue = Util.makeSignedDoubleWord(byte0, byte1, byte2, byte3);
                }
                OnlineTestInterpreter.this.writeVM(length, addr, newValue);
            }
        }
    }

    public static class OnlineTestTelegramBuffer {
        private int[] fBytes;
        private List fWatchedBlocks;

        public OnlineTestTelegramBuffer(int[] bytes, List watchedBlocks) {
            this.fBytes = bytes;
            this.fWatchedBlocks = watchedBlocks;
        }

        public int[] getBytes() {
            return this.fBytes;
        }

        public List getWatchedBlocks() {
            return this.fWatchedBlocks;
        }
    }
}

